unit Unit1;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Labdau;
type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
  end;

const labdaszam=5;
var
  Form1: TForm1;
  Labda:array [1..labdaszam] of TLabda;
const
  szin:array [1..labdaszam] of TColor=(clRed, clBlue, clGreen,clYellow,clPurple);

implementation

{$R *.DFM}

uses unit2;

procedure TForm1.FormCreate(Sender: TObject);
var i:integer;
begin
 for i:=1 to labdaszam do
   begin
     // ltrehozzuk a labdkat s elszrjuk a kpernyn
     Labda[i]:=TLabda.Create(Form1,szin[i]);
     // a labdk kezdsebessget kapnak
     Labda[i].dx:=1+i;
     Labda[i].dy:=1+i;
   end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
var i:integer;
begin
 // a labdk trlse
 for i:=1 to labdaszam do
  Labda[i].Free;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var segedpos:TPoint;
    i,j:integer;
    v1,v2:integer;
begin
  // az idzt mozgatja a labdkat
  for i:=1 to labdaszam-1 do
    for j:=i+1 to labdaszam do
      if Rect_(Labda[i],Labda[j]) then
        begin
          // ha a ktlabda tkzik, akkor teljesen rugalmas modellel
          // cserlik ki sebessgeiket
          v1:=Labda[i].dx;
          v2:=Labda[j].dx;
          Labda[i].dx:=v2;
          Labda[j].dx:=v1;
          v1:=Labda[i].dy;
          v2:=Labda[j].dy;
          Labda[i].dy:=v2;
          Labda[j].dy:=v1;
        end;
  // tkzskor irnyvlts a hatrokon
  for i:=1 to labdaszam do
   begin
     if (Labda[i].Pos.x+Labda[i].meret+Labda[i].dx>form1.clientwidth) or
        (Labda[i].Pos.x+Labda[i].dx<0) then Labda[i].dx:=-Labda[i].dx;
     if (Labda[i].Pos.y+Labda[i].meret+Labda[i].dy>form1.clientheight) or
        (Labda[i].Pos.y+Labda[i].dy<0) then  Labda[i].dy:=-Labda[i].dy;
     segedpos.x:=Labda[i].Pos.x+Labda[i].dx;
     segedpos.y:=Labda[i].Pos.y+Labda[i].dy;
     Labda[i].Pos:=segedpos;
   end;
end;

procedure TForm1.FormResize(Sender: TObject);
var segedpos:TPoint;
    i:integer;
begin
  for i:=1 to labdaszam do
    begin
     // tmretezskor a labdk jra rendezdnek
     segedpos.x:=(form1.clientwidth-Labda[i].meret) div i;
     if (i div 2)*2=i then
        segedpos.y:=(form1.clientheight-Labda[i].meret) div i
       else
        segedpos.y:=form1.clientheight-(form1.clientheight-Labda[i].meret) div i;
     Labda[i].Pos:=segedpos;
    end;
  Refresh;
end;

procedure TForm1.FormPaint(Sender: TObject);
var kiir:string;
    i:integer;
begin
     // a kperny kzepre szveget runk
     Canvas.Brush.Color:=Form1.Color;
     Canvas.Font.Color:=clDkGray;
     Canvas.Font.Size:=20;
     Canvas.Font.Style:=[fsBold];
     Canvas.Copymode:=cmSrcCopy;
     kiir:='Pattog pttys labdk';
     Canvas.TextOut((ClientWidth-Canvas.TextWidth(kiir)) div 2,
                    (ClientHeight-Canvas.TextHeight(kiir)) div 2,kiir);
     // s alappozciba helyezzk a labdt
     for i:=1 to labdaszam do
       Labda[i].Kirajz;
end;

end.
